/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.sas;

import com.ibm.hwmca.fw.rcs.sas.SasUtil;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;

public class RegisterUsers
implements Serializable {
    private static final String TRACE_MASKT = "XSASRUST";
    private static final String TRACE_MASKF = "XSASRUSF";
    private static final String TRACE_MASKD = "XSASRUSD";
    private static final String REGISTER_USERS = "register-users";
    public ArrayList EServiceUsers;

    public RegisterUsers() {
        Trace.trace(TRACE_MASKT, "<> RegisterUsers.RegisterUsers()");
        this.EServiceUsers = new ArrayList();
    }

    public void addUser(String userid, String auditLog) {
        Trace.trace(TRACE_MASKT, "-> RegisterUsers.addUser(userid= " + userid + ", " + "auditLog= " + auditLog + ")");
        EServiceUser eServiceUser = new EServiceUser(userid, auditLog);
        this.EServiceUsers.add(eServiceUser);
        Trace.trace(TRACE_MASKT, "<- RegisterUsers.addUser()");
    }

    public String toXml() {
        Trace.trace(TRACE_MASKT, "-> RegisterUsers.toXml()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(REGISTER_USERS);
        buffer.append(">");
        int i = 0;
        while (i < this.EServiceUsers.size()) {
            EServiceUser eServiceUser = (EServiceUser)this.EServiceUsers.get(i);
            buffer.append(eServiceUser.toXml());
            ++i;
        }
        buffer.append("</");
        buffer.append(REGISTER_USERS);
        buffer.append(">");
        Trace.trace(TRACE_MASKT, "<- RegisterUsers.toXml()");
        return buffer.toString();
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> RegisterUsers.clone()");
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- RegisterUsers.clone()");
        return object;
    }

    public boolean equals(Object object) {
        Trace.trace(TRACE_MASKT, "-> RegisterUsers.equals(" + object + ")");
        boolean result = false;
        if (object != null && object instanceof RegisterUsers) {
            RegisterUsers registerUsers = (RegisterUsers)object;
            if (this.EServiceUsers.equals(registerUsers.EServiceUsers)) {
                return true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- RegisterUsers.equals()");
        return result;
    }

    private static class EServiceUser
    implements Serializable {
        private static final String ESERVICE_USER = "eservice-user";
        private static final String USERID = "userid";
        private static final String AUDIT_LOG = "audit-log";
        public String userid;
        public String auditLog;

        public EServiceUser(String userid) {
            this(userid, null);
            Trace.trace(RegisterUsers.TRACE_MASKT, "<> EServiceUser.EServiceUser()");
        }

        public EServiceUser(String userid, String auditLog) {
            Trace.trace(RegisterUsers.TRACE_MASKT, "-> EServiceUser.EServiceUser(userid=" + userid + ", " + "auditLog=" + auditLog + ")");
            this.userid = userid;
            this.auditLog = auditLog;
            Trace.trace(RegisterUsers.TRACE_MASKT, "<- EServiceUser.EServiceUser()");
        }

        public String toXml() {
            Trace.trace(RegisterUsers.TRACE_MASKT, "-> EServiceUser.toXml()");
            StringBuffer buffer = new StringBuffer();
            buffer.append("<");
            buffer.append(ESERVICE_USER);
            buffer.append(" ");
            buffer.append("userid=\"" + SasUtil.convert4Xml(this.userid) + "\"");
            if (this.auditLog != null && this.auditLog.length() > 0) {
                buffer.append(" ");
                buffer.append("audit-log=\"" + SasUtil.convert4Xml(this.auditLog) + "\"");
            }
            buffer.append("/>");
            Trace.trace(RegisterUsers.TRACE_MASKT, "<- EServiceUser.toXml()");
            return buffer.toString();
        }

        public Object clone() {
            Trace.trace(RegisterUsers.TRACE_MASKT, "-> EServiceUser.clone()");
            Object object = null;
            try {
                object = super.clone();
            }
            catch (CloneNotSupportedException exc) {
                Trace.trace(RegisterUsers.TRACE_MASKF, exc);
            }
            Trace.trace(RegisterUsers.TRACE_MASKT, "<- EServiceUser.clone()");
            return object;
        }

        public boolean equals(Object object) {
            Trace.trace(RegisterUsers.TRACE_MASKT, "-> EServiceUser.equals(" + object + ")");
            boolean result = false;
            if (object != null && object instanceof EServiceUser) {
                EServiceUser eServiceUser = (EServiceUser)object;
                if (this.userid.equals(eServiceUser.userid) && this.auditLog.equals(eServiceUser.auditLog)) {
                    result = true;
                }
            }
            Trace.trace(RegisterUsers.TRACE_MASKT, "<- EServiceUser.equals()");
            return result;
        }
    }
}

